/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.store.TransactionStoreActivity;
import cz.insophy.inplan.store.TransactionStoreActivityTarget;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.ProductionTreeVisitorAdapter;
import cz.insophy.inplan.superplan.RelatedActivitiesCollector;
import cz.insophy.inplan.superplan.ReleaseDateTruncator;
import cz.insophy.inplan.superplan.StartEndQtyUpdater;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.IdentityHashSet;
import cz.insophy.inplan.util.TimeSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProductionTreeAlgorithms {
    private ProductionTreeAlgorithms() {
    }

    public static void changeFixationDate(Superplan superplan, long fixationDate) {
        superplan.setFixationDate(fixationDate);
        ReleaseDateTruncator.updateFrom(superplan, fixationDate);
        List<GeneralizedOrderRequest> gors = superplan.getGors();
        for (GeneralizedOrderRequest gor : gors) {
            boolean startBeforeFixation = GeneralizedOrderRequest.isDateValid(gor.getStartDate()) && gor.getStartDate() < fixationDate;
            switch (gor.getState()) {
                case PLANNING: {
                    if (!startBeforeFixation) break;
                    gor.setState(GeneralizedOrderRequest.State.WILL_BE_RELEASED);
                    break;
                }
                case WILL_BE_RELEASED: {
                    if (startBeforeFixation) break;
                    gor.setState(GeneralizedOrderRequest.State.PLANNING);
                    break;
                }
            }
        }
    }

    public static void addAa(ActionActivity aa, GeneralizedActionRequest parent) {
        if (parent.getSuperplan() != null) {
            parent.getSuperplan().getPlan().addActivity(aa);
        }
        parent.unsafeAddActivity(aa);
        parent.childChanged(aa);
    }

    public static void removeAa(ActionActivity aa, GeneralizedActionRequest parent) {
        if (parent != aa.getParent()) {
            throw new IllegalStateException(String.format("%s not a child of %s", aa, parent));
        }
        if (aa.getSuperplan() != null) {
            aa.getSuperplan().getPlan().removeActivity(aa);
        }
        if (parent != null) {
            parent.unsafeRemoveActivity(aa);
            parent.childChanged(aa);
        }
    }

    public static List<? extends ProductionTreeNode> removeRelatedActivities(ProductionTreeNode ptn) {
        List<ActionActivity> activities = RelatedActivitiesCollector.collectFrom(ptn);
        for (ActionActivity aa : activities) {
            GeneralizedActionRequest parent;
            if (ptn.getSuperplan() != null) {
                ptn.getSuperplan().getPlan().removeActivity(aa);
            }
            if ((parent = (GeneralizedActionRequest)aa.getParent()) == null) continue;
            parent.unsafeRemoveActivity(aa);
        }
        StartEndQtyUpdater.updateFrom(ProductionTreeAlgorithms.getFarthestGor(ptn));
        return activities;
    }

    public static double inPlanTillDate(GeneralizedRequest gr, long date) {
        double inPlanTillDate = 0.0;
        if (GeneralizedRequest.isDateValid(date)) {
            for (ActionActivity aa : RelatedActivitiesCollector.collectFrom(gr)) {
                if (aa.getEnd() > date) continue;
                inPlanTillDate += aa.getQty();
            }
        }
        return inPlanTillDate;
    }

    public static double plannedTillDate(GeneralizedRequest gr, long date) {
        double plannedTillDate = 0.0;
        if (GeneralizedRequest.isDateValid(date)) {
            plannedTillDate = ProductionTreeAlgorithms.inPlanTillDate(gr, date) + gr.getOutOfPlanQty();
        }
        return plannedTillDate;
    }

    public static double deviation(GeneralizedRequest gr, long date) {
        double deviation = 0.0;
        if (GeneralizedRequest.isDateValid(date)) {
            double completed = gr.getCompletedQty();
            deviation = completed - ProductionTreeAlgorithms.plannedTillDate(gr, date);
        }
        return deviation;
    }

    public static boolean isGarActive(GeneralizedActionRequest gar) {
        boolean isActive;
        Preconditions.checkNotNull(gar);
        double requestedQty = gar.getRequestedQty();
        double completedQty = gar.getCompletedQty();
        if (Comparators.compare(completedQty, requestedQty, 1.0E-7) >= 0) {
            isActive = false;
        } else if (Comparators.compare(completedQty, 0.0, 1.0E-7) > 0) {
            isActive = true;
        } else {
            GeneralizedActionRequest precedingGar;
            Action act = gar.getAction();
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            Preconditions.checkNotNull(gor);
            Actiongram actiongram = gor.getSelectedActiongram();
            Action precedingAction = actiongram.getPrecedingAction(act);
            isActive = precedingAction == null ? true : Comparators.compare((precedingGar = gor.getGar(precedingAction.getName())).getCompletedQty(), precedingGar.getRequestedQty(), 1.0E-7) >= 0;
        }
        return isActive;
    }

    public static double unplanQty(GeneralizedActionRequest gar, double qty, final UnplanFrom unplanFrom) {
        if (gar == null) {
            throw new IllegalArgumentException("GAR must not be null.");
        }
        if (qty < -1.0E-7) {
            throw new IllegalArgumentException("Qty must not be negative.");
        }
        ArrayList<ActionActivity> actsToProcess = Lists.newArrayList(gar.getActivities());
        Collections.sort(actsToProcess, new Comparator<ActionActivity>(){

            @Override
            public int compare(ActionActivity o1, ActionActivity o2) {
                int endTimeResult = Long.valueOf(o1.getEnd()).compareTo(o2.getEnd());
                int compResult = endTimeResult != 0 ? endTimeResult : Long.valueOf(o1.getStart()).compareTo(o2.getStart());
                return unplanFrom == UnplanFrom.BEGINING ? compResult : -compResult;
            }
        });
        Iterator aaIt = actsToProcess.iterator();
        while (qty > 1.0E-7 && aaIt.hasNext()) {
            ActionActivity aa = (ActionActivity)aaIt.next();
            double aaQty = aa.getQty();
            if ((qty -= aaQty) < -1.0E-7) {
                aa.setQty(Math.abs(qty));
                continue;
            }
            ProductionTreeAlgorithms.removeWorkplaceActivity(gar.getSuperplan(), aa);
        }
        if (qty < 1.0E-7) {
            qty = 0.0;
        }
        gar.childChanged(gar);
        return Math.max(qty, 0.0);
    }

    public static void cancelGorActiongram(GeneralizedOrderRequest gor) {
        List<ActionActivity> activities = RelatedActivitiesCollector.collectFrom(gor);
        for (ActionActivity aa : activities) {
            GeneralizedActionRequest parent;
            if (gor.getSuperplan() != null) {
                gor.getSuperplan().getPlan().removeActivity(aa);
            }
            if ((parent = (GeneralizedActionRequest)aa.getParent()) == null) continue;
            parent.unsafeRemoveActivity(aa);
        }
        gor.unsafeCancelActiongram();
    }

    public static void chooseGorActiongram(GeneralizedOrderRequest gor, Actiongram actiongram) {
        Preconditions.checkNotNull(gor);
        Preconditions.checkNotNull(actiongram);
        Preconditions.checkState(Collections3.containsObject(gor.getProduct().getActiongrams(), actiongram), "Cannot choose actiongram of different product for %s.", (Object)gor);
        gor.unsafeSetActiongram(actiongram);
        gor.updateSummaryData();
    }

    public static void addGor(Superplan superplan, GeneralizedOrderRequest gor) {
        for (ActionActivity aa : RelatedActivitiesCollector.collectFrom(gor)) {
            superplan.getPlan().addActivity(aa);
        }
        superplan.unsafeAddGor(gor);
        superplan.childChanged(gor);
    }

    public static List<? extends ProductionTreeNode> removeGor(GeneralizedOrderRequest gor, Superplan parent) {
        if (gor == null) {
            return Collections.emptyList();
        }
        if (parent != gor.getParent()) {
            throw new IllegalStateException(String.format("%s not a child of %s", gor, parent));
        }
        List<ActionActivity> activities = RelatedActivitiesCollector.collectFrom(gor);
        for (ActionActivity aa : activities) {
            if (gor.getSuperplan() != null) {
                gor.getSuperplan().getPlan().removeActivity(aa);
            }
            ((GeneralizedActionRequest)aa.getParent()).unsafeRemoveActivity(aa);
        }
        StartEndQtyUpdater.updateFrom(ProductionTreeAlgorithms.getFarthestGor(gor));
        parent.unsafeRemoveGor(gor);
        parent.childChanged(gor);
        gor.setPlan(null);
        ProductionTreeAlgorithms.updateStoresOnTargetRemoval(parent, gor);
        return activities;
    }

    protected static void updateStoresOnTargetRemoval(Superplan sp, TransactionStoreActivityTarget target) {
        ArrayList<TransactionStoreActivity> removedSas = Lists.newArrayList();
        Set<Material> affectedMaterials = ProductionTreeAlgorithms.getTargetedMaterials(target);
        StoreSchedule ss = sp.getPlan().getStoreSchedule(StoreType.TRANSACTION);
        HashSet<Material> affectedStoreMaterials = Sets.newHashSet(affectedMaterials);
        affectedStoreMaterials.retainAll(ss.getMaterials());
        for (StoreActivity storeActivity : ss.activities(affectedStoreMaterials)) {
            TransactionStoreActivity trSa = (TransactionStoreActivity)storeActivity;
            if (trSa.getTarget() != target) continue;
            removedSas.add(trSa);
        }
        for (StoreActivity storeActivity : removedSas) {
            sp.getPlan().removeActivity(storeActivity);
            sp.getPlan().addActivity(new ExternalStoreActivity(storeActivity.getTime(), storeActivity.getMaterial(), storeActivity.getQty()));
        }
    }

    private static Set<Material> getTargetedMaterials(TransactionStoreActivityTarget target) {
        if (!(target instanceof GeneralizedOrderRequest)) {
            throw new IllegalArgumentException();
        }
        Product product = ((GeneralizedOrderRequest)target).getProduct();
        Set<Material> res = product.materials();
        res.add(product);
        return res;
    }

    public static void addOffline(Superplan superplan, OfflineActivity offline) {
        superplan.getPlan().addActivity(offline);
    }

    public static void addRebuild(Superplan superplan, RebuildActivity rebuild) {
        superplan.getPlan().addActivity(rebuild);
    }

    public static void removeWorkplaceActivity(Superplan superplan, WorkplaceActivity wa) {
        if (wa instanceof ActionActivity) {
            ActionActivity aa = (ActionActivity)wa;
            ProductionTreeAlgorithms.removeAa(aa, aa.getGar());
        } else if (wa instanceof CumulativeWorkplaceActivity) {
            CumulativeWorkplaceActivity cwa = (CumulativeWorkplaceActivity)wa;
            for (ActionActivity aa : Lists.newArrayList(cwa.getActionActivities())) {
                ProductionTreeAlgorithms.removeAa(aa, aa.getGar());
            }
            superplan.getPlan().removeActivity(wa);
        } else if (wa instanceof RebuildActivity || wa instanceof OfflineActivity) {
            superplan.getPlan().removeActivity(wa);
        } else {
            throw new IllegalStateException("Unknown workplace activity type.");
        }
    }

    public static void changeStartToNorm(ActionActivity aa) {
        long timeToMake = aa.getAction().timeToMake(aa.getQty());
        timeToMake = Math.max(1L, timeToMake);
        long newStart = aa.getEnd() - timeToMake;
        if (newStart < aa.getStart()) {
            throw new IllegalStateException("New start date has to be >= old start date.");
        }
        aa.setStart(newStart);
    }

    public static void cutInTime(Superplan superplan, long time, boolean deleteAlternatives) {
        for (Workplace wp : superplan.getPlan().getShopConf().getWorkplaces()) {
            ProductionTreeAlgorithms.cutInTime(superplan, time, wp, deleteAlternatives);
        }
    }

    public static void cutInTime(Superplan superplan, long time, Workplace wp, boolean deleteAlternatives) {
        Iterator<WorkplaceActivity> waIterator = superplan.getPlan().getWorkplaceSchedule(wp).forwardIterator(time);
        ArrayList<WorkplaceActivity> wasToRemove = new ArrayList<WorkplaceActivity>();
        while (waIterator.hasNext()) {
            WorkplaceActivity wa = waIterator.next();
            if (!(wa instanceof ActionActivity) && !(wa instanceof RebuildActivity)) continue;
            wasToRemove.add(wa);
        }
        for (WorkplaceActivity wa : wasToRemove) {
            if (wa instanceof ActionActivity) {
                ActionActivity aa = (ActionActivity)wa;
                aa.getParent().unsafeRemoveChild(aa);
            }
            superplan.getPlan().removeActivity(wa);
        }
        if (deleteAlternatives) {
            for (GeneralizedOrderRequest gor : superplan.getGors()) {
                if (!RelatedActivitiesCollector.collectFrom(gor).isEmpty()) continue;
                gor.unsafeCancelActiongram();
            }
        }
        StartEndQtyUpdater.updateFrom(superplan);
    }

    public static void clearToFirstBottleneck(Superplan superplan, List<GeneralizedOrderRequest> gors, List<String> bottlenecks) {
        for (GeneralizedOrderRequest gor : gors) {
            ProductionTreeAlgorithms.clearToFirstBottleneck(gor, bottlenecks);
        }
        RebuildPlannerUtils.fixAndRegister(superplan.getPlan());
    }

    private static void clearToFirstBottleneck(GeneralizedOrderRequest gor, List<String> bottlenecks) {
        for (GeneralizedActionRequest gar : gor.getGars()) {
            gar.removeRelatedActivities();
            if (!bottlenecks.contains(gar.getAction().getCapabilityReq())) continue;
            break;
        }
    }

    public static Superplan getSuperplan(ProductionTreeNode ptn) {
        ProductionTreeNode furthestParent = ProductionTreeAlgorithms.getRoot(ptn);
        return furthestParent instanceof Superplan ? (Superplan)ProductionTreeAlgorithms.getRoot(ptn) : null;
    }

    public static ProductionTreeNode getRoot(ProductionTreeNode ptn) {
        if (ptn == null) {
            throw new IllegalArgumentException("PTN cannot be null");
        }
        ProductionTreeNode res = ptn;
        while (res.getParent() != null) {
            res = res.getParent();
        }
        return res;
    }

    public static GeneralizedOrderRequest getNearestGor(ProductionTreeNode ptn) {
        ProductionTreeNode res;
        if (ptn == null) {
            throw new IllegalArgumentException("PTN cannot be null");
        }
        for (res = ptn; !(res instanceof GeneralizedOrderRequest) && res != null; res = res.getParent()) {
        }
        return (GeneralizedOrderRequest)res;
    }

    public static GeneralizedOrderRequest getFarthestGor(ProductionTreeNode ptn) {
        if (ptn == null) {
            throw new IllegalArgumentException("PTN cannot be null");
        }
        if (ptn.getParent() == null) {
            return null;
        }
        ProductionTreeNode res = ptn;
        while (!(res.getParent() instanceof Superplan) && res.getParent() != null) {
            res = res.getParent();
        }
        return (GeneralizedOrderRequest)res;
    }

    public static ClearResult clearPlan(Superplan superplan, List<Workplace> workplaceList, Long from, Long to, boolean clearOfflines, boolean clearAas, boolean clearRebuilds, boolean deleteOverlapping, boolean deleteAlternatives, FixationLevel fixationProtection) {
        return ProductionTreeAlgorithms.clearPlan(superplan, workplaceList, from, to, clearOfflines, clearAas, clearRebuilds, deleteOverlapping, deleteAlternatives, true, fixationProtection);
    }

    public static ClearResult clearPlan(Superplan superplan, List<Workplace> workplaceList, Long from, Long to, boolean clearOfflines, boolean clearAas, boolean clearRebuilds, boolean deleteOverlapping, boolean deleteAlternatives, boolean updatePtns, FixationLevel fixationProtection) {
        return ProductionTreeAlgorithms.clearPlan(superplan, workplaceList, from, to, clearOfflines, clearAas, clearRebuilds, deleteOverlapping, deleteAlternatives, updatePtns, fixationProtection, false);
    }

    public static ClearResult clearPlan(Superplan superplan, List<Workplace> workplaceList, Long from, Long to, boolean clearOfflines, boolean clearAas, boolean clearRebuilds, boolean deleteOverlapping, boolean deleteAlternatives, boolean updatePtns, FixationLevel fixationProtection, boolean protectBlockedGARs) {
        if (workplaceList == null) {
            throw new NullPointerException("Parameter 'workplaceList' must not be null");
        }
        if (superplan == null) {
            throw new NullPointerException("Parameter 'superplan' must not be null");
        }
        if (from != null && to != null && from >= to) {
            throw new IllegalArgumentException("'from' argument must be smaller than 'to' argument.");
        }
        ArrayList<WorkplaceActivity> clearedWAList = new ArrayList<WorkplaceActivity>();
        Plan plan = superplan.getPlan();
        boolean fromMinusInf = from == null;
        boolean toPlusInf = to == null;
        Set<Object> protectedWas = Sets.newHashSet();
        if (clearAas) {
            protectedWas = ProductionTreeAlgorithms.collectFixedWas(superplan, fixationProtection);
        }
        if (protectBlockedGARs) {
            protectedWas.addAll(ProductionTreeAlgorithms.collectBlockedGarAas(superplan));
        }
        block0: for (Workplace workplace : workplaceList) {
            List<WorkplaceActivity> allActivities;
            WorkplaceSchedule schedule = plan.getWorkplaceSchedule(workplace);
            if (fromMinusInf) {
                allActivities = schedule.getActivities();
                long workplaceStart = Long.MAX_VALUE;
                for (WorkplaceActivity wa : allActivities) {
                    if (wa.getStart() >= workplaceStart) continue;
                    workplaceStart = wa.getStart();
                }
                from = workplaceStart;
            }
            if (toPlusInf) {
                allActivities = schedule.getActivities();
                long workplaceEnd = Long.MIN_VALUE;
                for (WorkplaceActivity wa : allActivities) {
                    if (wa.getEnd() <= workplaceEnd) continue;
                    workplaceEnd = wa.getEnd();
                }
                to = workplaceEnd;
            }
            Iterator<WorkplaceActivity> waIterator = schedule.forwardIterator(from, deleteOverlapping);
            while (waIterator.hasNext()) {
                WorkplaceActivity wa = waIterator.next();
                long waEnd = wa.getEnd();
                long waStart = wa.getStart();
                if (waStart >= to || waEnd > to && !deleteOverlapping) continue block0;
                if (waEnd > to && (waStart >= to || !deleteOverlapping) || !(wa instanceof ActionActivity && clearAas || wa instanceof CumulativeWorkplaceActivity && clearAas || wa instanceof RebuildActivity && clearRebuilds) && (!(wa instanceof OfflineActivity) || !clearOfflines)) continue;
                if (wa instanceof CumulativeWorkplaceActivity) {
                    CumulativeWorkplaceActivity cwa = (CumulativeWorkplaceActivity)wa;
                    for (ActionActivity aa : cwa.getActionActivities()) {
                        if (protectedWas.contains(aa)) continue;
                        clearedWAList.add(aa);
                    }
                    continue;
                }
                if (protectedWas.contains(wa)) continue;
                clearedWAList.add(wa);
            }
        }
        IdentityHashSet<GeneralizedOrderRequest> changedGors = new IdentityHashSet<GeneralizedOrderRequest>();
        for (WorkplaceActivity wa : clearedWAList) {
            ActionActivity aa;
            GeneralizedActionRequest gar;
            plan.removeActivity(wa);
            if (!(wa instanceof ActionActivity) || (gar = (GeneralizedActionRequest)(aa = (ActionActivity)wa).getParent()) == null) continue;
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            if (gor != null) {
                changedGors.add(gor);
            }
            gar.unsafeRemoveActivity(aa);
        }
        if (deleteAlternatives) {
            for (GeneralizedOrderRequest gor : changedGors) {
                if (gor.isFixed() || gor.isActiongramLocked() || !RelatedActivitiesCollector.collectFrom(gor).isEmpty()) continue;
                gor.unsafeCancelActiongram();
            }
        }
        if (updatePtns) {
            StartEndQtyUpdater.updateFrom(superplan);
        }
        return new ClearResult(clearedWAList, changedGors);
    }

    private static Set<WorkplaceActivity> collectBlockedGarAas(Superplan superplan) {
        HashSet<WorkplaceActivity> retVal = Sets.newHashSet();
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            for (GeneralizedActionRequest gar : gor.getGars()) {
                boolean blocked = gar.isBlocked();
                if (!blocked) continue;
                retVal.addAll(gar.getActivities());
            }
        }
        return retVal;
    }

    protected static Set<WorkplaceActivity> collectFixedWas(Superplan superplan, FixationLevel fixationLevel) {
        HashSet<WorkplaceActivity> fixedAas = Sets.newHashSet();
        long fixation = superplan.getFixationDate();
        if (fixationLevel == FixationLevel.NOTHING || !GeneralizedRequest.isDateValid(fixation)) {
            return fixedAas;
        }
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            if (gor.getStartDate() >= fixation) continue;
            if (fixationLevel == FixationLevel.GOR) {
                fixedAas.addAll(RelatedActivitiesCollector.collectFrom(gor));
                continue;
            }
            for (GeneralizedActionRequest gar : gor.getGars()) {
                if (gar.getStartDate() >= fixation) continue;
                if (fixationLevel == FixationLevel.GAR || fixationLevel == FixationLevel.GAR_REBUILD) {
                    fixedAas.addAll(RelatedActivitiesCollector.collectFrom(gar));
                    continue;
                }
                for (ActionActivity aa : gar.getActivities()) {
                    if (aa.getStart() >= fixation || fixationLevel != FixationLevel.AA && aa.getEnd() > fixation) continue;
                    fixedAas.add(aa);
                }
            }
        }
        if (fixationLevel == FixationLevel.GAR_REBUILD) {
            ProductionTreeAlgorithms.collectRebuildFixedWas(superplan, fixedAas);
        }
        return fixedAas;
    }

    protected static void collectRebuildFixedWas(Superplan superplan, Set<WorkplaceActivity> fixedWas) {
        long fix = superplan.getFixationDate();
        Preconditions.checkState(GeneralizedRequest.isDateValid(fix));
        block0: for (Workplace wp : superplan.getShopConf().getWorkplaces()) {
            WorkplaceSchedule wps = superplan.getPlan().getWorkplaceSchedule(wp);
            Iterator<WorkplaceActivity> iter = wps.forwardIterator();
            boolean rebuildFound = false;
            while (iter.hasNext()) {
                WorkplaceActivity wa = iter.next();
                if (wa instanceof OfflineActivity) continue;
                if (wa.getStart() < fix) {
                    rebuildFound = wa instanceof RebuildActivity;
                    continue;
                }
                if (!rebuildFound) continue block0;
                if (wa instanceof ActionActivity) {
                    fixedWas.addAll(RelatedActivitiesCollector.collectFrom(((ActionActivity)wa).getGar()));
                    continue block0;
                }
                if (wa instanceof CumulativeWorkplaceActivity) {
                    for (ActionActivity aa : ((CumulativeWorkplaceActivity)wa).getActionActivities()) {
                        fixedWas.addAll(RelatedActivitiesCollector.collectFrom(aa.getGar()));
                    }
                    continue block0;
                }
                if (!(wa instanceof RebuildActivity)) continue block0;
                fixedWas.add(wa);
            }
        }
    }

    public static TimeSpan getTimeBounds(ProductionTreeNode ptn) {
        TimeBoundsVisitor tbv = new TimeBoundsVisitor();
        ptn.accept(tbv, false);
        return TimeSpan.fromStartEnd(tbv.minTime, tbv.maxTime);
    }

    public static void cutOverplannedGars(ProductionTreeNode ptn) {
        OverplannedCutter cutter = new OverplannedCutter();
        ptn.accept(cutter, true);
    }

    public static enum UnplanFrom {
        BEGINING,
        END;

    }

    public static enum FixationLevel {
        NOTHING,
        FULLY_IN_FIXATION,
        AA,
        GAR,
        GAR_REBUILD,
        GOR;

    }

    public record ClearResult(Collection<WorkplaceActivity> removedWas, Collection<GeneralizedOrderRequest> affectedGors) {
    }

    private static class TimeBoundsVisitor
    extends ProductionTreeVisitorAdapter {
        public long minTime = Long.MAX_VALUE;
        public long maxTime = Long.MIN_VALUE;

        private TimeBoundsVisitor() {
        }

        private final void updateBounds(GeneralizedRequest r) {
            long dd;
            long rd = r.getReleaseDate();
            if (GeneralizedRequest.isDateValid(rd)) {
                if (this.minTime > rd) {
                    this.minTime = rd;
                }
                if (this.maxTime < rd) {
                    this.maxTime = rd;
                }
            }
            if (GeneralizedRequest.isDateValid(dd = r.getDueDate())) {
                if (this.minTime > dd) {
                    this.minTime = dd;
                }
                if (this.maxTime < dd) {
                    this.maxTime = dd;
                }
            }
        }

        @Override
        public void visit(GeneralizedOrderRequest gor) {
            this.updateBounds(gor);
        }

        @Override
        public void visit(GeneralizedActionRequest gar) {
            this.updateBounds(gar);
        }
    }

    private static class OverplannedCutter
    extends ProductionTreeVisitorAdapter {
        private OverplannedCutter() {
        }

        @Override
        public void visit(GeneralizedActionRequest gar) {
            if (gar.getPlannedQty() > gar.getRequestedQty()) {
                ProductionTreeAlgorithms.unplanQty(gar, Math.min(gar.getPlannedQty() - gar.getRequestedQty(), gar.getInPlanQty()), UnplanFrom.END);
            }
        }
    }
}

